using System;
using System.Collections;

namespace gov.va.med.vbecs.BOL
{
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Stanislav Antropov</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>9/28/2004</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	/// <summary>
	/// Base implementation of standard Comparer interface; used to compare business object properties via derived comparers.
	/// </summary>

	#endregion

	public abstract class BusinessObjectPropertyComparerBase : IComparer
	{
		///<Developers>
		///	<Developer>Stanislav Antropov</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/28/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5611"> 
		///		<ExpectedInput>Both arguments are nulls.</ExpectedInput>
		///		<ExpectedOutput>0</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="5612"> 
		///		<ExpectedInput>First argument is null, second is not.</ExpectedInput>
		///		<ExpectedOutput>-1</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="5613"> 
		///		<ExpectedInput>First argument is not null, second is null.</ExpectedInput>
		///		<ExpectedOutput>1</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="5615"> 
		///		<ExpectedInput>Both arguments are not null, object properties are equal.</ExpectedInput>
		///		<ExpectedOutput>0</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="5616"> 
		///		<ExpectedInput>Both are not null, first object's property is less than property of the second object.</ExpectedInput>
		///		<ExpectedOutput>-1</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="5617"> 
		///		<ExpectedInput>Both are not null, first object's property is greater than property of the second object.</ExpectedInput>
		///		<ExpectedOutput>1</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5614"> 
		///		<ExpectedInput>NA.</ExpectedInput>
		///		<ExpectedOutput>NA.</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Implementation of standard method, comparing two arguments.
		/// </summary>
		/// <param name="x">First object to compare.</param>
		/// <param name="y">Second object to compare.</param>
		/// <returns>0 if objects a equal, 1 if first is greater than second and -1 otherwise.</returns>
		public int Compare( object x, object y )
		{
			if( x == null && y == null )
				return 0; 

			if( x == null )
				return -1;

			if( y == null )
				return 1;

			return CompareProperties( x, y );
		}

		/// <summary>
		/// Method delegated to derived comparers. Descendants implementing this method 
		/// can safely assume that objects being compared are not nulls. 
		/// </summary>
		/// <param name="x">First object to compare.</param>
		/// <param name="y">Second object to compare.</param>
		/// <returns>0 if objects a equal, 1 if first is greater than second and -1 otherwise.</returns>
		protected abstract int CompareProperties( object x, object y );
	}
}
